/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api.wsrr;

import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.base.XMLHelper;
import filenet.vw.base.logging.Logger;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.wsrr.WSPublishToWSRR;
import filenet.ws.api.wsrr.WSWSRRUtilities;
import filenet.ws.api.wsrr.WSWSRRWsdlDocument;
import filenet.ws.api.wsrr.commonj.sdo.DataGraphType;
import filenet.ws.api.wsrr.serviceregistry_6_0.sdo.BaseObject;
import filenet.ws.api.wsrr.serviceregistry_6_0.sdo.Document;
import filenet.ws.api.wsrr.serviceregistry_6_0.sdo.GraphQuery;
import filenet.ws.api.wsrr.serviceregistry_6_0.sdo.UserDefinedProperty;
import filenet.ws.api.wsrr.serviceregistry_6_0.sdo.WSDLDocument;
import filenet.ws.api.wsrr.serviceregistry_6_0.sdo.WSRR;
import filenet.ws.api.wsrr.serviceregistry_6_0.sdo.XSDDocument;
import filenet.ws.api.wsrr.serviceregistry_6_0.ws.sdo.ServiceRegistryWebServiceException;
import filenet.ws.api.wsrr.serviceregistry_6_0.ws.sdo.WSRRCoreSDOPortType;
import filenet.ws.api.wsrr.serviceregistry_6_0.ws.sdo.WSRRCoreSDOServiceLocator;
import filenet.ws.utils.WSConstants;
import filenet.ws.utils.jsse.WSJSSE;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.axis.client.Stub;

public class WSWSRRRegistry {
    protected static Logger logger = Logger.getLogger("filenet.ws.api.wsrr");
    protected static final String m_className = "WSWSRRRegistry";
    public static String WSRR_PREFIX = "wsrr";
    public static final String P8BPM_WSRR_URI_DELIM = "!";
    protected VWSession m_session = null;
    protected int m_region = -1;
    protected String m_regionStr = null;
    private String m_serverName = null;
    private String m_cpName = null;
    protected String m_registryURL = null;
    protected URL m_url = null;
    protected String m_host = null;
    protected int m_port = -1;
    protected WSRRCoreSDOPortType m_queryWSRRCoreSDOPortType = null;
    protected WSRRCoreSDOPortType m_publishWSRRCoreSDOPortType = null;
    protected String m_queryUsername = null;
    protected String m_queryPassword = null;
    protected String m_publishUsername = null;
    protected String m_publishPassword = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addIBMSecurityProviders() {
        String m_method = "addIBMSecurityProviders";
        logger.entering(m_className, m_method);
        try {
            try {
                Class<?> IBMJSSEProvider2Class;
                Class<?> IBMJSSEProviderClass;
                Class<?> IBMJCEproviderClass;
                block35: {
                    block34: {
                        block33: {
                            IBMJCEproviderClass = null;
                            IBMJSSEProviderClass = null;
                            IBMJSSEProvider2Class = null;
                            try {
                                IBMJCEproviderClass = Class.forName("com.ibm.crypto.provider.IBMJCE");
                                if (logger.isFinest()) {
                                    logger.finest(m_className, m_method, "com.ibm.crypto.provider.IBMJCE found");
                                }
                            }
                            catch (Exception ex) {
                                if (!logger.isFinest()) break block33;
                                logger.finest(m_className, m_method, "com.ibm.crypto.provider.IBMJCE not found");
                            }
                        }
                        try {
                            IBMJSSEProviderClass = Class.forName("com.ibm.jsse.IBMJSSEProvider");
                            if (logger.isFinest()) {
                                logger.finest(m_className, m_method, "com.ibm.jsse.IBMJSSEProvider found");
                            }
                        }
                        catch (Exception ex) {
                            if (!logger.isFinest()) break block34;
                            logger.finest(m_className, m_method, "com.ibm.jsse.IBMJSSEProvider not found");
                        }
                    }
                    try {
                        IBMJSSEProvider2Class = Class.forName("com.ibm.jsse2.IBMJSSEProvider2");
                        if (logger.isFinest()) {
                            logger.finest(m_className, m_method, "com.ibm.jsse2.IBMJSSEProvider2 found");
                        }
                    }
                    catch (Exception ex) {
                        if (!logger.isFinest()) break block35;
                        logger.finest(m_className, m_method, "com.ibm.jsse2.IBMJSSEProvider2 not found");
                    }
                }
                if (IBMJSSEProviderClass != null || IBMJSSEProvider2Class != null) {
                    WSWSRRRegistry.setIBMProtocolHandlers();
                }
                boolean hasIBMJCEProvider = false;
                boolean hasIBMJSSEProvider = false;
                boolean hasIBMJSSEProvider2Class = false;
                Provider[] providers = Security.getProviders();
                for (int i = 0; i < providers.length; ++i) {
                    Class<?> cls = providers[i].getClass();
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, providers[i].toString());
                        logger.finest(m_className, m_method, cls.getName());
                    }
                    if (IBMJCEproviderClass != null && cls.equals(IBMJCEproviderClass)) {
                        hasIBMJCEProvider = true;
                        if (!logger.isFinest()) continue;
                        logger.finest(m_className, m_method, "Has IBM JCE Provider class - " + IBMJCEproviderClass.getName());
                        continue;
                    }
                    if (IBMJSSEProviderClass != null && cls.equals(IBMJSSEProviderClass)) {
                        hasIBMJSSEProvider = true;
                        if (!logger.isFinest()) continue;
                        logger.finest(m_className, m_method, "Has IBM JSSE Provider class - " + IBMJSSEProviderClass.getName());
                        continue;
                    }
                    if (IBMJSSEProvider2Class == null || !cls.equals(IBMJSSEProvider2Class)) continue;
                    hasIBMJSSEProvider2Class = true;
                    if (!logger.isFinest()) continue;
                    logger.finest(m_className, m_method, "Has IBM JSSE Provider2 class - " + IBMJSSEProvider2Class.getName());
                }
                if (!hasIBMJCEProvider) {
                    try {
                        if (IBMJCEproviderClass != null) {
                            Security.insertProviderAt((Provider)IBMJCEproviderClass.newInstance(), 1);
                            if (logger.isFinest()) {
                                logger.finest(m_className, m_method, "Added " + IBMJCEproviderClass.getName());
                            }
                        }
                    }
                    catch (Exception ex) {
                        logger.throwing(m_className, m_method, ex);
                    }
                }
                if (!hasIBMJSSEProvider) {
                    try {
                        if (IBMJSSEProviderClass != null) {
                            Security.insertProviderAt((Provider)IBMJSSEProviderClass.newInstance(), 1);
                            if (logger.isFinest()) {
                                logger.finest(m_className, m_method, "Added " + IBMJSSEProviderClass.getName());
                            }
                        }
                    }
                    catch (Exception ex) {
                        logger.throwing(m_className, m_method, ex);
                    }
                }
                if (!hasIBMJSSEProvider2Class) {
                    try {
                        if (IBMJSSEProvider2Class != null) {
                            Security.insertProviderAt((Provider)IBMJSSEProvider2Class.newInstance(), 1);
                            if (logger.isFinest()) {
                                logger.finest(m_className, m_method, "Added " + IBMJSSEProvider2Class.getName());
                            }
                        }
                    }
                    catch (Exception ex) {
                        logger.throwing(m_className, m_method, ex);
                    }
                }
                Object var11_18 = null;
                logger.exiting(m_className, m_method);
            }
            catch (Throwable t) {
                logger.throwing(m_className, m_method, t);
                Object var11_19 = null;
                logger.exiting(m_className, m_method);
            }
        }
        catch (Throwable throwable) {
            Object var11_20 = null;
            logger.exiting(m_className, m_method);
            throw throwable;
        }
    }

    private static void setIBMProtocolHandlers() {
        String m_method = "setIBMProtocolHandlers";
        logger.entering(m_className, m_method);
        String IBMHandler = "com.ibm.net.ssl.www2.protocol";
        String handlerProperty = "java.protocol.handler.pkgs";
        Properties properties = System.getProperties();
        String handler = System.getProperty(handlerProperty);
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "Orig protocol handler property " + handlerProperty + " = " + handler);
        }
        if (handler == null) {
            properties.setProperty(handlerProperty, IBMHandler);
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "Handler set: " + handlerProperty + " = " + IBMHandler);
            }
        } else if (handler.indexOf(IBMHandler) == -1) {
            String handlers = IBMHandler.concat("|").concat(handler);
            properties.setProperty(handlerProperty, handlers);
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "Handler added: " + handlerProperty + " = " + handlers);
            }
        }
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "Handler property " + handlerProperty + " = " + System.getProperty(handlerProperty));
        }
        logger.exiting(m_className, m_method);
    }

    public void releaseReferences() {
        block2: {
            try {
                this.m_session = null;
                this.m_regionStr = null;
                this.m_serverName = null;
                this.m_cpName = null;
                this.m_registryURL = null;
                this.m_url = null;
                this.m_host = null;
                this.m_queryWSRRCoreSDOPortType = null;
                this.m_publishWSRRCoreSDOPortType = null;
                this.m_queryUsername = null;
                this.m_queryPassword = null;
                this.m_publishUsername = null;
                this.m_publishPassword = null;
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block2;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    public static WSWSRRRegistry newWSRRRegistry(VWSession session, String host, int port) throws VWException {
        String m_method = "newWSRRRegistry";
        try {
            return new WSWSRRRegistry(session, host, port);
        }
        catch (VWException ex) {
            throw ex;
        }
        catch (MalformedURLException ex) {
            logger.throwing(m_className, m_method, ex);
            throw new VWException(ex);
        }
    }

    public static WSWSRRRegistry newWSRRRegistry(VWSession session, String host) throws VWException {
        return WSWSRRRegistry.newWSRRRegistry(session, host, -1);
    }

    public boolean isConnected() throws VWException {
        try {
            URL aURL = this.getWSRRURL(this.m_host, this.m_port);
            if (aURL == null) {
                return false;
            }
            try {
                this.retrieveWSDLDocumentsByName("xyz", true);
                return true;
            }
            catch (VWException ex) {
                String cause = ex.getCauseDescription();
                if (cause.indexOf("401") != -1) {
                    return true;
                }
                throw new VWException(ex);
            }
        }
        catch (Exception ex) {
            throw new VWException(ex);
        }
    }

    private URL getWSRRURL(String host, int port) throws MalformedURLException, VWException {
        String m_method = "getWSRRURL - " + host + ":" + port;
        URL url = null;
        url = port == -1 ? new URL("http", host, "/WSRRCoreSDO/services/WSRRCoreSDOPort") : new URL("http", host, port, "/WSRRCoreSDO/services/WSRRCoreSDOPort");
        HttpURLConnection httpConnection = null;
        try {
            try {
                URLConnection connection = url.openConnection();
                if (connection instanceof HttpURLConnection) {
                    httpConnection = (HttpURLConnection)connection;
                    httpConnection.setRequestMethod("GET");
                    httpConnection.setDoOutput(true);
                    httpConnection.connect();
                    int response = httpConnection.getResponseCode();
                    if (response == 302) {
                        String location = httpConnection.getHeaderField("Location");
                        if (location != null) {
                            url = new URL(location);
                            if (logger.isFinest()) {
                                logger.finest(m_className, m_method, location);
                            }
                        }
                    } else if (response != 200) {
                        String responseMsg = httpConnection.getResponseMessage();
                        VWException vwex = new VWException("filenet.ws.api.wsrr.WSRRConnectionError", "WSRR connection failed - {0}", responseMsg);
                        logger.throwing(m_className, m_method, vwex);
                        throw vwex;
                    }
                }
                Object var11_12 = null;
                if (httpConnection != null) {
                    httpConnection.disconnect();
                }
            }
            catch (Throwable t) {
                logger.throwing(m_className, m_method, t);
                throw new VWException(t);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (httpConnection != null) {
                httpConnection.disconnect();
            }
            throw throwable;
        }
        return url;
    }

    WSWSRRRegistry(VWSession session, String host, int port) throws MalformedURLException, VWException {
        this.m_session = session;
        if (this.m_session != null) {
            this.m_serverName = session.getServerName();
            this.m_region = session.getIsolatedRegion();
            this.m_regionStr = Integer.toString(this.m_region);
            this.m_cpName = session.getConnectionPointName();
        }
        this.m_host = host;
        this.m_port = port;
        this.m_url = this.getWSRRURL(host, port);
        this.m_registryURL = this.m_url.toString();
        this.init();
    }

    private void init() throws VWException {
        String m_method = "init";
        try {
            WSRRCoreSDOServiceLocator wsrrCoreServiceLocator = new WSRRCoreSDOServiceLocator();
            this.m_queryWSRRCoreSDOPortType = wsrrCoreServiceLocator.getWSRRCoreSDOPort(new URL(this.m_registryURL));
            this.m_publishWSRRCoreSDOPortType = wsrrCoreServiceLocator.getWSRRCoreSDOPort(new URL(this.m_registryURL));
        }
        catch (Throwable t) {
            VWException vwex = new VWException(t);
            logger.throwing(m_className, m_method, vwex);
            throw vwex;
        }
    }

    public int getRegion() {
        return this.m_region;
    }

    public String getRegistryURL() {
        return this.m_registryURL;
    }

    public String getRegisteryHostName() {
        if (this.m_url != null) {
            return this.m_url.getHost();
        }
        return null;
    }

    int getPort() {
        return this.m_port;
    }

    public String getQueryUsername() {
        return this.m_queryUsername;
    }

    String getQueryPassword() {
        return this.m_queryPassword;
    }

    public String getPublishUsername() {
        return this.m_publishUsername;
    }

    public void setQueryUsernamePassword(String username, String password) {
        if (username != null && (username = username.trim()).length() == 0) {
            username = null;
        }
        if (password != null && (password = password.trim()).length() == 0) {
            password = null;
        }
        this.m_queryUsername = username;
        this.m_queryPassword = password;
        this.setUsernamePassword(this.m_queryWSRRCoreSDOPortType, this.m_queryUsername, this.m_queryPassword);
    }

    public void setPublishUsernamePassword(String username, String password) {
        if (username != null && (username = username.trim()).length() == 0) {
            username = null;
        }
        if (password != null && (password = password.trim()).length() == 0) {
            password = null;
        }
        this.m_publishUsername = username;
        this.m_publishPassword = password;
        this.setUsernamePassword(this.m_publishWSRRCoreSDOPortType, this.m_publishUsername, this.m_publishPassword);
    }

    public boolean isNonSecureLink() {
        return this.m_url.getProtocol().compareToIgnoreCase("http") == 0;
    }

    public boolean hasPublishCredential() {
        if (this.m_url.getProtocol().compareToIgnoreCase("http") == 0) {
            return true;
        }
        return this.m_publishUsername != null && this.m_publishPassword != null;
    }

    public boolean hasQueryCredential() {
        if (this.m_url.getProtocol().compareToIgnoreCase("http") == 0) {
            return true;
        }
        return this.m_queryUsername != null && this.m_queryPassword != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateUser(String username, String password) throws VWException {
        this.setUsernamePassword(this.m_queryWSRRCoreSDOPortType, username, password);
        try {
            this.retrieveWSDLDocumentsByName("xyz", true);
            boolean bl = true;
            Object var7_5 = null;
            this.setUsernamePassword(this.m_queryWSRRCoreSDOPortType, this.m_queryUsername, this.m_queryPassword);
            return bl;
        }
        catch (VWException ex) {
            block5: {
                try {
                    String cause = ex.getCauseDescription();
                    if (cause.indexOf("401") == -1) break block5;
                    boolean bl = false;
                    Object var7_6 = null;
                    this.setUsernamePassword(this.m_queryWSRRCoreSDOPortType, this.m_queryUsername, this.m_queryPassword);
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    this.setUsernamePassword(this.m_queryWSRRCoreSDOPortType, this.m_queryUsername, this.m_queryPassword);
                    throw throwable;
                }
            }
            boolean bl = true;
            Object var7_7 = null;
            this.setUsernamePassword(this.m_queryWSRRCoreSDOPortType, this.m_queryUsername, this.m_queryPassword);
            return bl;
        }
    }

    private void setUsernamePassword(WSRRCoreSDOPortType wsrrCoreSDOPortType, String username, String password) {
        if (wsrrCoreSDOPortType != null && wsrrCoreSDOPortType instanceof Stub) {
            ((Stub)wsrrCoreSDOPortType).setUsername(username);
            ((Stub)wsrrCoreSDOPortType).setPassword(password);
        }
    }

    Document retriveDocumentByBsrURI(String bsrURI) throws VWException {
        String m_method = "retriveDocumentByBsrURI";
        try {
            BaseObject baseObject;
            DataGraphType dg = this.m_queryWSRRCoreSDOPortType.retrieve(bsrURI);
            if (dg != null && dg != null && (baseObject = WSWSRRUtilities.getRootObject(dg)) != null && baseObject instanceof Document) {
                return (Document)baseObject;
            }
        }
        catch (Throwable t) {
            VWException vwex = new VWException(t);
            throw vwex;
        }
        return null;
    }

    public WSWSRRWsdlDocument[] getAllWSDLDocuments() throws VWException {
        String m_method = "getAllWSDLDocuments";
        try {
            DataGraphType[] resultArray = this.m_queryWSRRCoreSDOPortType.executeNamedQuery("getAllWSDLDocuments");
            ArrayList<WSWSRRWsdlDocument> list = new ArrayList<WSWSRRWsdlDocument>();
            if (resultArray != null) {
                for (int i = 0; i < resultArray.length; ++i) {
                    BaseObject baseObject;
                    DataGraphType dg = resultArray[i];
                    if (dg == null || (baseObject = WSWSRRUtilities.getRootObject(dg)) == null || !(baseObject instanceof WSDLDocument)) continue;
                    list.add(new WSWSRRWsdlDocument(this, dg));
                }
            }
            return this.listToWSDLDocuments(list);
        }
        catch (ServiceRegistryWebServiceException srwse) {
            VWException vwex = new VWException((Throwable)((Object)srwse));
            logger.throwing(m_className, m_method, vwex);
            throw vwex;
        }
        catch (Throwable t) {
            VWException vwex = new VWException(t);
            logger.throwing(m_className, m_method, vwex);
            throw vwex;
        }
    }

    public WSWSRRWsdlDocument[] retrieveRegionWSDLDocuments() throws VWException {
        String m_method = "getRegionWSDLDocuments";
        if (this.m_session != null) {
            String[] parameters = new String[]{"IsolatedRegion", this.m_regionStr, "PEServer", this.m_serverName, "ConnectionPoint", this.m_cpName};
            return this.retrieveWSDLDocumentWithParameters(parameters);
        }
        return null;
    }

    public WSWSRRWsdlDocument[] retrieveWSDLDocuments(String queryString, boolean bCaseSensitive) throws VWException {
        if (queryString != null) {
            queryString = queryString.trim();
        }
        if (queryString == null || queryString.length() == 0 || queryString.compareTo("*") == 0) {
            return this.getAllWSDLDocuments();
        }
        StringBuffer sBuf = new StringBuffer();
        if (queryString.indexOf("*") != -1) {
            queryString = new String("x") + queryString + "x";
            StringTokenizer st = new StringTokenizer(queryString, "*");
            while (st.hasMoreElements()) {
                sBuf.append(st.nextElement()).append(".*");
            }
            sBuf.delete(sBuf.length() - 3, sBuf.length());
            sBuf.deleteCharAt(0);
            queryString = sBuf.toString();
        }
        return this.retrieveWSDLDocumentsByQueryString(queryString, bCaseSensitive);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WSWSRRWsdlDocument[] retrieveWSDLDocumentsByQueryString(String queryString, boolean bCaseSensitive) throws VWException {
        WSWSRRWsdlDocument[] wSWSRRWsdlDocumentArray;
        String m_method = "retrieveWSDLDocuments(" + queryString + ")";
        if (logger.isFinest()) {
            logger.entering(m_className, m_method);
        }
        try {
            try {
                if (queryString == null || queryString.trim().length() == 0 || queryString.compareTo(".*") == 0) {
                    WSWSRRWsdlDocument[] wSWSRRWsdlDocumentArray2 = this.getAllWSDLDocuments();
                    Object var12_8 = null;
                    if (!logger.isFinest()) return wSWSRRWsdlDocumentArray2;
                    logger.exiting(m_className, m_method);
                    return wSWSRRWsdlDocumentArray2;
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append("/WSRR/WSDLDocument[");
                buffer.append("matches(@name,'").append(queryString).append("'");
                if (bCaseSensitive) {
                    buffer.append(")]");
                } else {
                    buffer.append(",'i')]");
                }
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "queryString = " + buffer.toString());
                }
                DataGraphType[] resultArray = this.executeQuery(buffer.toString());
                WSWSRRWsdlDocument doc = null;
                ArrayList<WSWSRRWsdlDocument> list = new ArrayList<WSWSRRWsdlDocument>();
                if (resultArray != null) {
                    for (int i = 0; i < resultArray.length; ++i) {
                        BaseObject baseObject;
                        DataGraphType dg = resultArray[i];
                        if (dg == null || (baseObject = WSWSRRUtilities.getRootObject(dg)) == null || !(baseObject instanceof WSDLDocument)) continue;
                        doc = new WSWSRRWsdlDocument(this, dg);
                        list.add(doc);
                    }
                }
                wSWSRRWsdlDocumentArray = this.listToWSDLDocuments(list);
            }
            catch (ServiceRegistryWebServiceException srwse) {
                VWException vwex = new VWException((Throwable)((Object)srwse));
                logger.throwing(m_className, m_method, vwex);
                throw vwex;
            }
            catch (Throwable t) {
                VWException vwex = new VWException(t);
                logger.throwing(m_className, m_method, vwex);
                throw vwex;
            }
        }
        catch (Throwable throwable) {
            Object var12_10 = null;
            if (!logger.isFinest()) throw throwable;
            logger.exiting(m_className, m_method);
            throw throwable;
        }
        Object var12_9 = null;
        if (!logger.isFinest()) return wSWSRRWsdlDocumentArray;
        logger.exiting(m_className, m_method);
        return wSWSRRWsdlDocumentArray;
    }

    public WSWSRRWsdlDocument[] retrieveWSDLDocumentsByName(String name, boolean bCaseSensitive) throws VWException {
        String m_method = "retrieveWSDLDocumentsWithName(" + name + ")";
        if (name == null || name.trim().length() == 0) {
            return this.getAllWSDLDocuments();
        }
        return this.retrieveWSDLDocumentsByQueryString(name, bCaseSensitive);
    }

    public WSWSRRWsdlDocument retrieveWSDLDocumentByBsrURI(String wsrrBsrURI) throws VWException {
        return new WSWSRRWsdlDocument(this, wsrrBsrURI);
    }

    public void deleteWSDLDocument(String wssrBsrURI) throws VWException {
        String m_method = "deleteWSDLDocument: " + wssrBsrURI;
        try {
            this.m_publishWSRRCoreSDOPortType.delete(wssrBsrURI);
        }
        catch (Exception ex) {
            VWException vwex = new VWException(ex);
            logger.throwing(m_className, m_method, vwex);
            throw vwex;
        }
    }

    public int publish(String workClassName) throws VWException {
        WSPublishToWSRR publisToWSRR = new WSPublishToWSRR(this.m_session, workClassName);
        return publisToWSRR.publish(this);
    }

    public int publish(VWWorkflowSignature signature) throws VWException {
        int result = -1;
        String m_method = "publish";
        if (logger.isFinest()) {
            logger.entering(m_className, m_method);
        }
        WSPublishToWSRR publisToWSRR = new WSPublishToWSRR(this.m_session, signature);
        result = publisToWSRR.publish(this);
        if (logger.isFinest()) {
            logger.exiting(m_className, m_method);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    WSWSRRWsdlDocument createWSDLDocument(String docURL, String name, String namespace, org.w3c.dom.Document defDoc, String version, String description, String encoding, String[] properties) throws VWException {
        String m_method = "createWSDLDocument";
        if (logger.isFinest()) {
            logger.entering(m_className, m_method);
        }
        try {
            try {
                name = WSDefinition.UTF8Encode(name);
                description = WSDefinition.UTF8Encode(description);
                byte[] byteArray = XMLHelper.DOMDocToUTF8ByteArray(defDoc);
                WSDLDocument wsdlDoc = this.newWSDLDocument(docURL, namespace, byteArray);
                if (name != null && name.trim().length() > 0) {
                    wsdlDoc.setName(name.trim());
                }
                if (description != null && description.trim().length() > 0) {
                    wsdlDoc.setDescription(description.trim());
                }
                if (version != null && version.trim().length() > 0) {
                    wsdlDoc.setVersion(version.trim());
                }
                if (encoding != null && encoding.trim().length() > 0) {
                    wsdlDoc.setEncoding(encoding.trim());
                }
                String key = null;
                String value = null;
                if (properties != null && properties.length >= 2) {
                    UserDefinedProperty[] udps = new UserDefinedProperty[properties.length / 2];
                    int index = 0;
                    for (int i = 0; i < properties.length; i += 2, ++index) {
                        key = properties[i];
                        value = properties[i + 1];
                        if (key == null || value == null) continue;
                        key = key.trim();
                        value = value.trim();
                        if (key.length() <= 0 || value.length() <= 0) continue;
                        udps[index] = new UserDefinedProperty();
                        udps[index].setName(key);
                        udps[index].setValue(value);
                    }
                    wsdlDoc.setUserDefinedProperties(udps);
                }
                wsdlDoc.setBsrURI("_1");
                BaseObject[] artefactArray = new BaseObject[]{wsdlDoc};
                DataGraphType dg = WSWSRRUtilities.createDataGraph(artefactArray, "_1");
                String wsdlBsrURI = this.m_publishWSRRCoreSDOPortType.create(dg);
                WSWSRRWsdlDocument wSWSRRWsdlDocument = new WSWSRRWsdlDocument(this, wsdlBsrURI);
                Object var19_24 = null;
                if (!logger.isFinest()) return wSWSRRWsdlDocument;
                logger.exiting(m_className, m_method);
                return wSWSRRWsdlDocument;
            }
            catch (ServiceRegistryWebServiceException srwse) {
                VWException vwex = new VWException((Throwable)((Object)srwse));
                logger.throwing(m_className, m_method, vwex);
                throw vwex;
            }
            catch (Throwable t) {
                VWException vwex = new VWException(t);
                logger.throwing(m_className, m_method, vwex);
                throw vwex;
            }
        }
        catch (Throwable throwable) {
            Object var19_25 = null;
            if (!logger.isFinest()) throw throwable;
            logger.exiting(m_className, m_method);
            throw throwable;
        }
    }

    public WSWSRRWsdlDocument[] retrieveWSDLDocumentByNameAndNamespace(String name, String namespace) throws VWException {
        String m_method = "retrieveWSDLDocumentByURL";
        ArrayList<WSWSRRWsdlDocument> list = new ArrayList<WSWSRRWsdlDocument>();
        WSWSRRWsdlDocument[] wsrrDocs = null;
        try {
            String[] parameters = new String[]{"namespace", namespace};
            DataGraphType[] resultArray = this.m_queryWSRRCoreSDOPortType.executeNamedQueryWithParameters("getWSDLDocument", parameters);
            if (resultArray != null) {
                WSDLDocument wsdlDoc = null;
                for (int i = 0; i < resultArray.length; ++i) {
                    BaseObject baseObject;
                    DataGraphType dg = resultArray[i];
                    if (dg == null || (baseObject = WSWSRRUtilities.getRootObject(dg)) == null || !(baseObject instanceof WSDLDocument) || (wsdlDoc = (WSDLDocument)baseObject).getName().compareTo(name) != 0) continue;
                    list.add(new WSWSRRWsdlDocument(this, dg));
                }
                if (list.size() > 0) {
                    wsrrDocs = new WSWSRRWsdlDocument[list.size()];
                    list.toArray(wsrrDocs);
                }
            }
        }
        catch (ServiceRegistryWebServiceException ex) {
            wsrrDocs = this.retrieveWSDLDocuments(name, true);
            if (wsrrDocs != null && wsrrDocs.length > 0) {
                Object doc = null;
                Vector<WSWSRRWsdlDocument> docs = new Vector<WSWSRRWsdlDocument>();
                String aNamespace = null;
                for (int i = 0; i < wsrrDocs.length; ++i) {
                    if (wsrrDocs[i] == null || !(wsrrDocs[i] instanceof WSWSRRWsdlDocument) || (aNamespace = WSConstants.UTF8Decode(wsrrDocs[i].getNamespace())) == null || namespace.compareTo(wsrrDocs[i].getNamespace()) != 0) continue;
                    docs.add(wsrrDocs[i]);
                }
                if (docs.size() > 0) {
                    wsrrDocs = new WSWSRRWsdlDocument[docs.size()];
                    wsrrDocs = docs.toArray(wsrrDocs);
                    docs.clear();
                    doc = null;
                } else {
                    wsrrDocs = null;
                }
            }
            return wsrrDocs;
        }
        catch (Throwable t) {
            VWException vwex = new VWException(t);
            logger.throwing(m_className, m_method, vwex);
            throw vwex;
        }
        return wsrrDocs;
    }

    private WSWSRRWsdlDocument[] listToWSDLDocuments(ArrayList list) {
        WSWSRRWsdlDocument[] wsdlDocuments = null;
        if (list != null && list.size() > 0) {
            wsdlDocuments = new WSWSRRWsdlDocument[list.size()];
            list.toArray(wsdlDocuments);
        }
        return wsdlDocuments;
    }

    public WSWSRRWsdlDocument[] retrieveWSDLDocumentWithParameters(String[] parameters) throws VWException {
        String m_method = "retrieveWSDLDocumentWithParameters";
        ArrayList<WSWSRRWsdlDocument> list = new ArrayList<WSWSRRWsdlDocument>();
        try {
            DataGraphType[] resultArray;
            StringBuffer query = new StringBuffer("/WSRR/WSDLDocument");
            if (parameters != null && parameters.length >= 2) {
                int i = 0;
                while (i + 1 < parameters.length) {
                    if (i == 0) {
                        query.append("[");
                    } else {
                        query.append(" and ");
                    }
                    query.append("@").append(parameters[i]).append("=").append("'").append(parameters[i + 1]).append("'");
                    i += 2;
                }
                query.append("]");
            }
            if ((resultArray = this.executeQuery(query.toString())) != null) {
                for (int i = 0; i < resultArray.length; ++i) {
                    BaseObject baseObject;
                    DataGraphType dg = resultArray[i];
                    if (dg == null || (baseObject = WSWSRRUtilities.getRootObject(dg)) == null || !(baseObject instanceof WSDLDocument)) continue;
                    list.add(new WSWSRRWsdlDocument(this, dg));
                }
            }
        }
        catch (Throwable t) {
            VWException vwex = new VWException(t);
            logger.throwing(m_className, m_method, vwex);
            throw vwex;
        }
        return this.listToWSDLDocuments(list);
    }

    DataGraphType retrieveWSDLDocument(String bsrURI) throws VWException {
        String m_method = "retrieveWSDLDocumentByURL";
        try {
            BaseObject baseObject;
            DataGraphType dg = this.m_queryWSRRCoreSDOPortType.retrieve(bsrURI);
            if (dg != null && dg != null && (baseObject = WSWSRRUtilities.getRootObject(dg)) != null && baseObject instanceof WSDLDocument) {
                return dg;
            }
        }
        catch (Throwable t) {
            VWException vwex = new VWException(t);
            logger.throwing(m_className, m_method, vwex);
            throw vwex;
        }
        return null;
    }

    BaseObject retrieveWSRRDocument(String bsrURI) throws VWException {
        String m_method = "retrieveWSDLDocumentByURL";
        try {
            BaseObject baseObject;
            DataGraphType dg = this.m_queryWSRRCoreSDOPortType.retrieve(bsrURI);
            if (dg != null && dg != null && (baseObject = WSWSRRUtilities.getRootObject(dg)) != null && (baseObject instanceof WSDLDocument || baseObject instanceof XSDDocument)) {
                return baseObject;
            }
        }
        catch (Throwable t) {
            VWException vwex = new VWException(t);
            logger.throwing(m_className, m_method, vwex);
            throw vwex;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private WSDLDocument newWSDLDocument(String docURL, String namespace, byte[] wsdlContent) throws VWException {
        String m_method = "newWSDLDocument - " + docURL;
        WSDLDocument doc = null;
        if (docURL != null) {
            try {
                if (wsdlContent != null) {
                    doc = new WSDLDocument();
                    doc.setNamespace(namespace);
                    doc.setLocation(docURL);
                    if (wsdlContent == null) return doc;
                    doc.setContent(wsdlContent);
                    return doc;
                }
                VWException vwex = new VWException("filenet.ws.api.nullWSDLContent", "null WSDL content");
                logger.throwing(m_className, m_method, vwex);
                throw vwex;
            }
            catch (Throwable t) {
                VWException vwex = new VWException(t);
                logger.throwing(m_className, m_method, vwex);
                throw vwex;
            }
        } else {
            VWException vwex = new VWException("filenet.ws.api.nullWSDLurl", "null WSDL url");
            logger.throwing(m_className, m_method, vwex);
            throw vwex;
        }
    }

    private DataGraphType[] executeQuery(String query) throws VWException {
        String m_method = "executeQuery: " + query;
        try {
            GraphQuery gq = new GraphQuery();
            gq.setBsrURI("_1");
            gq.setQueryExpression(query);
            BaseObject[] artefactsArray = new BaseObject[]{gq};
            WSRR wsrr = new WSRR();
            wsrr.setArtefacts(artefactsArray);
            wsrr.setRoot("_1");
            DataGraphType dg = new DataGraphType();
            dg.setWSRR(wsrr);
            DataGraphType[] response = this.m_queryWSRRCoreSDOPortType.executeQuery(dg);
            return response;
        }
        catch (Throwable t) {
            throw new VWException(t);
        }
    }

    public String toString() {
        return this.m_url.getHost();
    }

    public static String _get_FILE_DATE() {
        return "$Date:   30 Sep 2008 14:49:20  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.21  $";
    }

    static {
        WSWSRRRegistry.addIBMSecurityProviders();
        try {
            WSJSSE.installAxisJSSESocketFactory(null);
        }
        catch (Exception ex) {
            logger.throwing(m_className, "filenet.ws.utils.jsse.WSJSSE.installAxisJSSESocketFactory", ex);
        }
    }
}

